(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     80257,       1943]
NotebookOptionsPosition[     79360,       1909]
NotebookOutlinePosition[     79701,       1924]
CellTagsIndexPosition[     79658,       1921]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.71653065352419*^9, 3.716530665980612*^9}, 
   3.7329489367237263`*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\<\\t\>\""}], ",", 
   RowBox[{"\"\<RepeatedSeparators\>\"", "\[Rule]", "False"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.716531505782024*^9, 3.7165315083186445`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rawData20nm", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<q_20_13_v2++.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rawData50nm", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<q_50_13++.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rawData100nm11UC", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<q_100_11++.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.716530630999312*^9, 3.7165306871900363`*^9}, 
   3.7165310287146235`*^9, {3.7165313411988297`*^9, 3.716531341830735*^9}, {
   3.7165313725971193`*^9, 3.7165313729978237`*^9}, {3.7165315034112043`*^9, 
   3.7165315273928995`*^9}, {3.716531710649194*^9, 3.7165317173064876`*^9}, {
   3.73294896672759*^9, 3.73294896707564*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"rawData20nm", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"rawData50nm", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"rawData100nm11UC", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.7165306922956038`*^9, 3.716530692833233*^9}, {
   3.7165313468336477`*^9, 3.7165313475872793`*^9}, {3.7165315354982214`*^9, 
   3.7165315557686453`*^9}, {3.7165317241567445`*^9, 3.716531737379461*^9}, 
   3.7329489898611083`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"q_20_13_v2\"\>", "\<\"f_20_13_v2\"\>"},
    {"\<\"f_50_13\"\>", "\<\"q_50_13\"\>"},
    {"\<\"q_100_11\"\>", "\<\"f_100_11\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.716530693449726*^9, 3.716530848523879*^9, 3.7165310316007376`*^9, 
   3.7165310711530657`*^9, {3.7165313436189013`*^9, 3.716531348487353*^9}, {
   3.7165315524670687`*^9, 3.7165315560901957`*^9}, {3.7165317253442497`*^9, 
   3.716531738079822*^9}, 3.7329489902507005`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"qvsf20nm", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"rawData20nm", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"rawData20nm", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qvsf50nm", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"rawData50nm", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"rawData50nm", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qvsf100nm11UC", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"rawData100nm11UC", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"rawData100nm11UC", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.71653070525771*^9, 3.716530748122913*^9}, {
  3.71653103560431*^9, 3.7165310571859164`*^9}, {3.7165311046473866`*^9, 
  3.716531192324956*^9}, {3.7165313572441034`*^9, 3.7165313600845995`*^9}, {
  3.7165315660928454`*^9, 3.716531608029643*^9}, {3.716531743469723*^9, 
  3.7165317595828037`*^9}, {3.7329489956886606`*^9, 3.732948995939704*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"qvsf20nm", ",", "qvsf50nm", ",", "qvsf100nm11UC"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Frequency, Hz\>\"", ",", "\"\<Quality factor\>\""}], 
     "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Quality factors of 2.6 mm phononic crystal beams\\nwithout \
tapering\>\""}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<SiN thickness = 20 nm\>\"", ",", "\"\<SiN thickness = 50 nm\>\"", 
      ",", "\"\<SiN thickness = 100 nm\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.716530753209182*^9, 3.7165307567886577`*^9}, {
   3.7165312007875743`*^9, 3.7165312247120748`*^9}, {3.716531647554428*^9, 
   3.716531664376751*^9}, 3.7165317661906614`*^9, {3.7329490147078342`*^9, 
   3.7329490239454603`*^9}, {3.732949093784343*^9, 3.7329492609996276`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0]], 
        PointBox[CompressedData["
1:eJxVlA1QTGsYxw9p6M6l6GZziaLMSrUfTZuune08Z99VVpII1bVjMl1h2L3X
x93FkL5mhSlfqXwVxopbbWPu3J2N0V25iSKsQWXKCF007IQYkzjeV513Z87s
/OY553n+z/953jcgTZ+YPpxhmIyvD//P/zLrEOS7ZT0auCdleS58jiDYbfqL
++Nk3zjWoAFFkXn0HgeOl91RgSjOseX9B8x11Ur6e3cpMI7RGdMWYj5rlEG8
IxwlHZF84+KLCNJjmpKDG3F+8TMVfMg7nGirxe93WhHIubrU3mYcH3EeQdj1
qBvHuzCz5QjuX2UaVr/DbChBsLlhfuSxvZi7cxF8dPoN19ZjttZzUOPy63Lr
kmO9/hKqHiOSwcSnaxatP47ZIJZT7OWvgPJ1lrFNJsyZskgQl1qqmoJIfN8s
yo/Cxig48y5pysx2kr/tFzCFyHdsryTfeytBr0lRpnwmnKOCNMM19c5JMqIv
GmYHtfp0RGP2ncBS/bVka6AgYKA9Zylm41MN+DSWWlqCMM+yx4DzrMt7VB7O
L+2IBW6b4mjlLdLf1rmUHqtIC/Zn/1wpV2A2NmhhTIzlr71FmG0r54Gm72SB
buN3/XFg6WjekLoUc+wAB7/uC/skysH+loWwlD6+P+E+tYxTU+8XurPgbjpa
O+cEmedyFVzqUd0ID8DcGaWm8r1ZoYb/axJm37Hi740b1cBNfpiqK8XMmNXQ
33bao70Ks1e1mupP2k/Xt3khCPAcFmIqwMwGIirftUgE45P+rq1ZizlhHgKn
9uBdWwLmFX8gCH0Vrk+WyAf3cU72pVPR9qH98/y8LOJJG/HnGAcRc2NW5tpI
/5s5Sm/mAg5MN50qiZHkE3PQ8/B3ZfISUr8VaH3/AZVPugfggDivazyHuXgh
QHf5hAbnv8QfEVB6zcEAdnNKduIwcj62sPDcz74/4xw5nyxLzZ+PC/fR9xOC
ok1OsIkwP9Ah6r7g/RL2w/sv9I9nof5iBx03H6Hj/LyF+TLmq+GyqyLnigHz
sun0/Pn9nKrPWuWjkQ/OQzhv33yOmi/vf9zEKG3izSH/S5abXfubhvzX5qPz
t08P+S+cB3sBqP3i5xH6Q6VrdT/2xz8dwEM/MrRQR/ZTBdS+MANvWY+q3r6Z
FRLCI6jzk7ndk7ovOq0/UXFG9zP8WXN1d/MoUm/sFCjbkBbYHUfmt34qdV8b
SgLhpXbJ6we5pN7jGdCszKs/uJWc97q3LBX/qmeXrbrNu1s6qEd43/H14hVZ
P27qJfdjRSBULo4/ZOkJG8z/sk+Z+hsjZb8AP+b8eg==
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 1, 0]], 
        PointBox[CompressedData["
1:eJxV0g9MlHUYB/BXooTZIaYGrKt1YQjjOO4VPM8Bx32PO6GLY5wcd0w2OTKU
CcvT4p/UcUO5nHmEiAZOkf4wjriwTRyMFVynASFujhyxgigtqai4UjqYNQqf
F+x9t3fvPnve32/PP9FLB3YW+DEMY/jvXfouPcEKFk/9uD/rlWapcsnui2Lc
dP6xPsBObvFGoUK8pcr6Edl8O4LnZwtEaBI+1hz26fJ5IWRnjglOeMg2NgT5
brdvtofMhKzDfNGFAcVXy/HVKM669U9x7bJ9yqdT43S6cPLHV7fw4spN8bz8
bhzZCqvmzkTYW8v5yXhxZr+cZ9t723Gq+Ub02iIu/6gEuGI6Gy5auHrzE7HR
ptT6TLEPLP0sCYGdd33R7eSWUQXapq6/mmui/0PDlPCXfRtdk8TVf1iJkpTf
/dhScvkjQO+d7ivvyshpFg3OhztaO9pYym9BA1FGr2FKQG6M28Hrj/n2DsRY
6yePdZPrclIRlNrmcpwh5wSk4Xqi/WpDJbnxgzTIn8kK0mWTf9r3Ar7z9PUX
5ZEj/bU45eg6PZDM5TeoBeMRFIbryT17XkTVy8fv+anIAZvTYbRe+fpPOdfv
sXT8fz6Ndh0iz7Z1jjzP5SvLQJHiy/ih9dz8FvhuEWdixpeYu5fh+lGbiTd+
2R21bZj6WziRiSf7i1+bziMHK/S8/m/4QY9zQsPB4Enyr707MaM1zo7XkJ0/
Z/H6Pb7bgLKTTOWqMoqPTBoQkmzfrJdw8wzKxptlFfedwlhun7Jh396hLvRJ
Hlg8lI3P19SusY5JuPkYefF7ZUa0Rvz9uqZews3LiJKp48m3zGQba0LT1sHA
ofwYqvd7vm+ezYFT0OzsLCV7L+2CpLw61DQaTf3o0yBDVv14yV0pV18KBAtz
Hd+Mxa7E2104Mh1P+zOfoELuoxumZQp2Zd/Wng74sK6GHHpfDf8vGg5cTiDb
3GrkzeOSOI4771JjfLGq++Q1sqVJjfeHvYMH68k5ESm8/XDPqKAennFFzVE+
8nEVb5+W7q+4vPo3vZvOmw+pEZLuOfzXPMW95hSUDuq2nXc8vH/gaOBorZRd
ub9ysdUleo5cV6qCfN0ck7SPzlsiVWjox94RCcV7LgDVCfqMPdqHXnVoY1dX
F9e/cvDqadQD7RbPExM26YrfFi1OHDWx3P4BDuE7fdc+IXtnldjFSkYL8qXK
fwEhzZ/u
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1]], 
        PointBox[CompressedData["
1:eJxV0nlIk3EYB/Blpv1j3qKRR5jmNZ06Fed0ezZfN5yTeaQZOO+jFLbAo9IK
hUxCPPAaaWmmGJkhYeFRaqIlUjBQp6aJSnk10xRzHlDp86Jt8DI+fJ89v+d5
9zsfLwlN0qBQKJx/z8H3wactjAaS5/ocAZ3GPnDsljuUdnSJGf5ovWovsN1/
PE/YoVWnfMCc5y4UWqMvx/lB56QiotEY3dHEBh35tAd13+XQ6YsEZHJ/arhm
YV6hyQO9vC8+0XOYK2t5sHptYHwkAe1EDYRR6hOtKEu0noYAvuorzgTInQ/N
HAwC3YvzNe81Mf/ULIRKB//IGBXmoqJgSFFo3h8oRHfYicC8bHih3gNdJAyF
uVrlZoEzOlY7BPauKg37lqmHlvNY0JRJNxlfwP6lDCYU1V3Yu25A7vubAV1c
07qPVmipHQduOrndvdOKTu0h4EMWdfJXMv7eapoD8WwiVDaDOT+BCzai7o3E
FXRxHhe01wNte7Vccd8qLvBfFm+e/Uz2z/EGg26Kp6c2en2NBqKpRPvvLS5H
1tN5NC9uJOdtcYaEfofMHgusn9ikQbXtQpZqkpwnjA6Ozx5ESkwwX9r3gOgX
DwdNtMj/P9wbZh13UsrlWE+ZYoAkpL2d/Q7dVsiE1vDgyuZVfH/sJV/YHTsX
RVRgnprPgo1Xnk/TJOi+bTa41pvXck6S+0sJWNptTWKEkfclL0Ct/jTBA7ns
jfI1j5y3gw8WLuX8XQpaZiyA9N64G5YyPF+qFMDgLcNpXSE6XFcE35j82fY2
KnkfnGHcWqzd6YDnyVh0tXlUuUzILqPknMjG/oXTvnB7RWzvNYyWRrLgR2DE
2sS94310drZaphRoWoEbpPmN0IcMsR+FzYLlP1ZVQQ2YFynYan7rTgCx3VAi
zsD6IRselJhOpIxqkvdxUAAzAZKd0BQ0P98NkgdKt8z0sb7eiA7B/e7+l2qw
38SYB8zuWVyBZfSQmbfaeapChlp9arEvmPSmZyzGHM/3/765RsTR+/oLestE
Zg==
         "]]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {0, 13.549379022293879`}, 
     PlotRange -> {{0, 7.*^6}, {13.634161646911405`, 18.890684373198102`}}, 
     PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
     Identity, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0, 13.549379022293879`}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox["\"Quality factor\"", TraditionalForm], None}, {
        FormBox["\"Frequency, Hz\"", TraditionalForm], None}}, FrameStyle -> 
     GrayLevel[0], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Quality factors of 2.6 mm phononic crystal beams\\nwithout \
tapering\"", TraditionalForm], 
     PlotRange -> {{0, 7.*^6}, {13.634161646911405`, 18.890684373198102`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"SiN thickness = 20 nm\"", "\"SiN thickness = 50 nm\"", 
       "\"SiN thickness = 100 nm\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7165307584992104`*^9, 3.7165310598654737`*^9, 3.7165311220206404`*^9, 
   3.716531225856884*^9, 3.7165315983223476`*^9, 3.7165316648234205`*^9, 
   3.716531768054889*^9, {3.732948998155734*^9, 3.732949024868334*^9}, 
   3.732949129466384*^9, {3.73294919515204*^9, 3.732949220814706*^9}, 
   3.7329492619702344`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "select", " ", "only", " ", "modes", " ", "from", " ", "the", " ", 
     "approximate", " ", "bandgap", " ", "location"}], ",", " ", "fRange"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fRange", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.2", ",", "2.6"}], "}"}], 
     SuperscriptBox["10", "6"]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7165318244649305`*^9, 3.7165318383737745`*^9}, 
   3.7165319408888807`*^9, 3.716531982149163*^9, {3.73294927174224*^9, 
   3.732949299923099*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"qvsf20nmSel", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"qvsf20nm", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", 
         RowBox[{"fRange", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "&&", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", 
         RowBox[{"fRange", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qvsf50nmSel", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"qvsf50nm", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", 
         RowBox[{"fRange", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "&&", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", 
         RowBox[{"fRange", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qvsf100nmSel", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"qvsf100nm11UC", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", 
         RowBox[{"fRange", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "&&", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", 
         RowBox[{"fRange", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7165318208479137`*^9, 3.7165319080401773`*^9}, {
  3.7329493142236433`*^9, 3.732949380632949*^9}, {3.732949450163365*^9, 
  3.732949499133441*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"qvsf20nmSel", ",", "qvsf50nmSel", ",", "qvsf100nmSel"}], "}"}], 
   ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Frequency, Hz\>\"", ",", "\"\<Quality factor\>\""}], 
     "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.716530753209182*^9, 3.7165307567886577`*^9}, {
   3.7165312007875743`*^9, 3.7165312247120748`*^9}, {3.716531647554428*^9, 
   3.716531664376751*^9}, 3.7165317661906614`*^9, {3.716531916694032*^9, 
   3.71653192383355*^9}, {3.7329496508860703`*^9, 3.732949678560404*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQDQIbjjg5bvwo+4T5iZEDiO/x38kxZqLeb/EWCP+C
kDMK/4Gls2O/4v87LeGGYP6HBGfHlxsDrC9tgMhXlDg7OsndjI6bBeEzdDg7
/r29hPPOOghfYL2z465n2w8vNDNwgNnP/y/C9PFtiPyCuU6Opp7uya07IPwJ
ZU4o+hv8nRwrz12x06+A8As0nBzf3iy0iQyD8ANuOaLYf+KYI4p5Bj2OjpM1
2p6IOUH4MwIdHV8slDx+5SDUveKOjrpvjPMj9SH8Di1Hx10dUc1BjFD1h5wd
r3hNubwjACo/2xnFfJD/kd2X4evsuP/jypbDBRB+hBpqeIDCWym/KV3U1Qge
Hor8jDqV/RC+RJeTo1jo1t0bsxH+95G29Ao6h/D/zNiOj5POIPzv1eWy+uIS
hP+Rw8NhsyNKfILCQ5dr7cfMv5D4VEh1dOTMZ9edEAeNLztHR7fmvYvtdxk6
AABa46x5
      "]]}, 
    {RGBColor[0, 1, 0], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[{{2.23*^6, 16.213405830762646`}, {2.39*^6, 
      17.2430252479438}, {2.51*^6, 16.25785759333348}, {2.48*^6, 
      15.978833583624812`}, {2.47*^6, 16.316946509703484`}, {2.54*^6, 
      17.553180176247643`}, {2.51*^6, 17.18967926723851}, {2.48*^6, 
      17.133326330687378`}, {2.42*^6, 16.40327459319198}, {2.38*^6, 
      17.182806387950748`}, {2.31*^6, 17.290577788192884`}, {2.31*^6, 
      16.70588231586044}, {2.29*^6, 17.572048660552024`}, {2.27*^6, 
      16.503358051748965`}, {2.27*^6, 17.341871082580436`}, {2.26*^6, 
      17.73748389424559}, {2.22*^6, 16.38045991542581}}]}, 
    {RGBColor[0, 0, 1], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[{{2.38*^6, 16.67771143889374}, {2.472*^6, 
      16.869511739642242`}, {2.5412*^6, 16.915602846842507`}, {2.5567*^6, 
      17.02635421113521}, {2.5672*^6, 16.801192495664765`}, {2.224*^6, 
      16.012735135300492`}, {2.224*^6, 15.919644712234481`}, {2.207*^6, 
      15.816990558174398`}, {2.207*^6, 
      15.89495209964411}}]}, {}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{2.201015625*^6, 15.593899878051712`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Quality factor\"", TraditionalForm], None}, {
     FormBox["\"Frequency, Hz\"", TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Automatic, Automatic}}, {{{{16.11809565095832, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {16.811242831518264`, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "2", 
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {17.72753356339242, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "5", 
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {18.420680743952367`, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
           
           TemplateBox[{"10", "8"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {15.424948470398375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.60727002719233, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.761420707019587`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.89495209964411, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.012735135300492`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.523560759066484`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.216707939626428`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.50439001207821, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.909855120186375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.064005800013632`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.197537192638155`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.31532022829454, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.82614585206053, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.11382792451231, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.519293032620475`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.806975105072254`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.030118656386467`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.21244021318042, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.36659089300768, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.5001222856322, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.617905321288585`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.72326583694641, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}, {{16.11809565095832, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {16.811242831518264`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {17.72753356339242, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {18.420680743952367`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {15.424948470398375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.60727002719233, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.761420707019587`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.89495209964411, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.012735135300492`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.523560759066484`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.216707939626428`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.50439001207821, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.909855120186375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.064005800013632`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.197537192638155`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.31532022829454, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.82614585206053, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.11382792451231, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.519293032620475`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.806975105072254`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.030118656386467`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.21244021318042, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.36659089300768, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.5001222856322, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.617905321288585`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.72326583694641, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, Automatic}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{2.207*^6, 2.59*^6}, {15.646229790673083`, 18.890684373198102`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, 
    Charting`ScaledTicks[{Log, Exp}]}]], "Output",
 CellChangeTimes->{{3.716531924341992*^9, 3.7165319427437153`*^9}, 
   3.716531983894094*^9, {3.732949355460561*^9, 3.7329493826950493`*^9}, {
   3.7329494587996607`*^9, 3.7329495022671337`*^9}, {3.732949654319438*^9, 
   3.732949679142408*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"20", ",", 
          RowBox[{"Length", "[", "qvsf20nmSel", "]"}]}], "]"}], ",", 
        RowBox[{"qvsf20nmSel", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"50", ",", 
          RowBox[{"Length", "[", "qvsf50nmSel", "]"}]}], "]"}], ",", 
        RowBox[{"qvsf50nmSel", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"100", ",", 
          RowBox[{"Length", "[", "qvsf100nmSel", "]"}]}], "]"}], ",", 
        RowBox[{"qvsf100nmSel", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"15", ",", "150"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", "7"], ",", 
        RowBox[{"2", " ", 
         SuperscriptBox["10", "8"]}]}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(Si\), \(3\)]\)\!\(\*SubscriptBox[\(N\), \(4\)]\
\) thickness, nm\>\"", ",", "\"\<Quality factor\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<In-bandgap quality factors\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7329497156914263`*^9, 3.7329498821969433`*^9}, {
  3.7329499210905113`*^9, 3.7329500453675117`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQPfFxcbXTd3aHjR9lnzA/MXKA8WMm6v0Wb8HN71f8
f6cl3BDOf7kxwPrSBoS8k9zN6LhZCP7f20s476xD8Hc92354oZkBnM//L8L0
8W2EvKmne3LrDtz6K89dsdOvQPDf3iy0iQzDbT+6eZM12p6IOSH4LxZKHr9y
EMHXfWOcH6mP5N6OqOYgRgT/iteUyzsCcJuP7r79H1e2HC7A7R+l/KZ0UVcE
X5GfUaeyH8EXC926e2M2gu8jbekVdA7Bnxnb8XHSGQTfq8tl9cUluMMDPT51
udZ+zPyLiE/OfHbdCXEIebfmvYvtdxk6AAA1RwFv
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], 
     PointBox[{{3.912023005428146, 16.213405830762646`}, {3.912023005428146, 
      17.2430252479438}, {3.912023005428146, 16.25785759333348}, {
      3.912023005428146, 15.978833583624812`}, {3.912023005428146, 
      16.316946509703484`}, {3.912023005428146, 17.553180176247643`}, {
      3.912023005428146, 17.18967926723851}, {3.912023005428146, 
      17.133326330687378`}, {3.912023005428146, 16.40327459319198}, {
      3.912023005428146, 17.182806387950748`}, {3.912023005428146, 
      17.290577788192884`}, {3.912023005428146, 16.70588231586044}, {
      3.912023005428146, 17.572048660552024`}, {3.912023005428146, 
      16.503358051748965`}, {3.912023005428146, 17.341871082580436`}, {
      3.912023005428146, 17.73748389424559}, {3.912023005428146, 
      16.38045991542581}}]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], 
     PointBox[{{4.605170185988092, 16.67771143889374}, {4.605170185988092, 
      16.869511739642242`}, {4.605170185988092, 16.915602846842507`}, {
      4.605170185988092, 17.02635421113521}, {4.605170185988092, 
      16.801192495664765`}, {4.605170185988092, 16.012735135300492`}, {
      4.605170185988092, 15.919644712234481`}, {4.605170185988092, 
      15.816990558174398`}, {4.605170185988092, 
      15.89495209964411}}]}, {}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{2.7195631265671802`, 16.13307431232609},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Quality factor\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(Si\\), \\(3\\)]\\)\\!\\(\\*SubscriptBox[\\(N\
\\), \\(4\\)]\\) thickness, nm\"", TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{16.11809565095832, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {16.811242831518264`, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "2", 
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {17.72753356339242, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "5", 
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {18.420680743952367`, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
           
           TemplateBox[{"10", "8"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {19.11382792451231, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "2", 
           TemplateBox[{"10", "8"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {15.424948470398375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.60727002719233, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.761420707019587`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.89495209964411, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.012735135300492`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.523560759066484`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.216707939626428`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.50439001207821, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.909855120186375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.064005800013632`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.197537192638155`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.31532022829454, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.82614585206053, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.519293032620475`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.806975105072254`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.030118656386467`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.21244021318042, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.36659089300768, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.5001222856322, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.617905321288585`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.72326583694641, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}, {{16.11809565095832, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {16.811242831518264`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {17.72753356339242, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {18.420680743952367`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {19.11382792451231, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {15.424948470398375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.60727002719233, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.761420707019587`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {15.89495209964411, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.012735135300492`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16.523560759066484`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.216707939626428`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.50439001207821, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17.909855120186375`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.064005800013632`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.197537192638155`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.31532022829454, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18.82614585206053, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.519293032620475`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19.806975105072254`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.030118656386467`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.21244021318042, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.36659089300768, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.5001222856322, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.617905321288585`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {20.72326583694641, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}, {{{2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {2.302585092994046, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.70805020110221, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.0943445622221, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.248495242049359, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.382026634673881, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.499809670330265, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.298317366548036, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}, {{2.995732273553991, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {3.912023005428146, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {4.605170185988092, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {2.302585092994046, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.70805020110221, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.0943445622221, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.248495242049359, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.382026634673881, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.499809670330265, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.298317366548036, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Log, Exp}, {Log, Exp}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Log, Exp}, {Log, Exp}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Log, Exp}, {Log, Exp}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Log, Exp}, {Log, Exp}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"In-bandgap quality factors\"", TraditionalForm],
  PlotRange->NCache[{{
      Log[15], 
      Log[150]}, {
      Log[10000000], 
      Log[200000000]}}, {{2.70805020110221, 5.0106352940962555`}, {
    16.11809565095832, 19.11382792451231}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}], 
    Charting`ScaledTicks[{Log, Exp}]}]], "Output",
 CellChangeTimes->{{3.7329497996431217`*^9, 3.732949882851676*^9}, {
  3.7329499457976437`*^9, 3.7329499812178154`*^9}, {3.7329500182440596`*^9, 
  3.7329500459306793`*^9}}]
}, Open  ]]
},
WindowSize->{922, 657},
WindowMargins->{{6, Automatic}, {11, Automatic}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 216, 5, 30, "Input"],
Cell[777, 27, 266, 6, 30, "Input"],
Cell[1046, 35, 874, 20, 69, "Input"],
Cell[CellGroupData[{
Cell[1945, 59, 570, 13, 30, "Input"],
Cell[2518, 74, 939, 22, 77, "Output"]
}, Open  ]],
Cell[3472, 99, 1630, 47, 69, "Input"],
Cell[CellGroupData[{
Cell[5127, 150, 1214, 27, 88, "Input"],
Cell[6344, 179, 19513, 397, 272, "Output"]
}, Open  ]],
Cell[25872, 579, 587, 16, 50, "Input"],
Cell[26462, 597, 1845, 57, 69, "Input"],
Cell[CellGroupData[{
Cell[28332, 658, 926, 20, 50, "Input"],
Cell[29261, 680, 19953, 483, 325, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49251, 1168, 2187, 58, 189, "Input"],
Cell[51441, 1228, 27903, 678, 259, "Output"]
}, Open  ]]
}
]
*)

